/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.Platform;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.NativeType;
import org.python.modules.jffi.Util;

public class FastIntInvokerFactory {
    private FastIntInvokerFactory() {
    }

    public static final FastIntInvokerFactory getFactory() {
        return SingletonHolder.INSTANCE;
    }

    final boolean isFastIntMethod(CType cType, CType[] cTypeArray) {
        for (int i = 0; i < cTypeArray.length; ++i) {
            if (this.isFastIntParam(cTypeArray[i])) continue;
            return false;
        }
        return cTypeArray.length <= 3 && this.isFastIntResult(cType);
    }

    final boolean isFastIntMethod(PyObject pyObject, PyObject[] pyObjectArray) {
        for (int i = 0; i < pyObjectArray.length; ++i) {
            if (this.isFastIntParam(pyObjectArray[i])) continue;
            return false;
        }
        return pyObjectArray.length <= 3 && this.isFastIntResult(pyObject);
    }

    final boolean isFastIntResult(CType cType) {
        if (cType instanceof CType.Builtin) {
            switch (cType.getNativeType()) {
                case VOID: 
                case BYTE: 
                case UBYTE: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: {
                    return true;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
                case STRING: {
                    return Platform.getPlatform().addressSize() == 32;
                }
            }
        }
        return false;
    }

    final boolean isFastIntResult(PyObject pyObject) {
        return this.isFastIntResult(CType.typeOf(pyObject));
    }

    final boolean isFastIntParam(CType cType) {
        if (cType instanceof CType.Builtin) {
            switch (cType.getNativeType()) {
                case BYTE: 
                case UBYTE: 
                case SHORT: 
                case USHORT: 
                case INT: 
                case UINT: {
                    return true;
                }
                case LONG: 
                case ULONG: {
                    return Platform.getPlatform().longSize() == 32;
                }
            }
        }
        return false;
    }

    final boolean isFastIntParam(PyObject pyObject) {
        return this.isFastIntParam(CType.typeOf(pyObject));
    }

    final Invoker createInvoker(Function function, CType[] cTypeArray, CType cType) {
        IntParameterConverter[] intParameterConverterArray = new IntParameterConverter[cTypeArray.length];
        for (int i = 0; i < intParameterConverterArray.length; ++i) {
            intParameterConverterArray[i] = this.getIntParameterConverter(cTypeArray[i]);
        }
        return this.createIntInvoker(function, this.getIntResultConverter(cType), intParameterConverterArray);
    }

    final Invoker createInvoker(Function function, PyObject pyObject, PyObject[] pyObjectArray) {
        IntParameterConverter[] intParameterConverterArray = new IntParameterConverter[pyObjectArray.length];
        for (int i = 0; i < intParameterConverterArray.length; ++i) {
            intParameterConverterArray[i] = this.getIntParameterConverter(pyObjectArray[i]);
        }
        return this.createIntInvoker(function, this.getIntResultConverter(pyObject), intParameterConverterArray);
    }

    final Invoker createIntInvoker(Function function, IntResultConverter intResultConverter, IntParameterConverter[] intParameterConverterArray) {
        switch (intParameterConverterArray.length) {
            case 0: {
                return new FastIntInvokerZero(function, intResultConverter, intParameterConverterArray);
            }
            case 1: {
                return new FastIntInvokerOne(function, intResultConverter, intParameterConverterArray);
            }
            case 2: {
                return new FastIntInvokerTwo(function, intResultConverter, intParameterConverterArray);
            }
            case 3: {
                return new FastIntInvokerThree(function, intResultConverter, intParameterConverterArray);
            }
        }
        throw Py.RuntimeError("fast int invoker does not support functions with arity=" + intParameterConverterArray.length);
    }

    final IntParameterConverter getIntParameterConverter(CType cType) {
        if (cType instanceof CType.Builtin) {
            return this.getIntParameterConverter(cType.getNativeType());
        }
        throw Py.TypeError("cannot convert objects of type " + cType + " to int");
    }

    final IntParameterConverter getIntParameterConverter(PyObject pyObject) {
        return this.getIntParameterConverter(CType.typeOf(pyObject));
    }

    final IntParameterConverter getIntParameterConverter(NativeType nativeType) {
        switch (nativeType) {
            case BYTE: {
                return Signed8ParameterConverter.INSTANCE;
            }
            case UBYTE: {
                return Unsigned8ParameterConverter.INSTANCE;
            }
            case SHORT: {
                return Signed16ParameterConverter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16ParameterConverter.INSTANCE;
            }
            case INT: {
                return Signed32ParameterConverter.INSTANCE;
            }
            case UINT: {
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Signed32ParameterConverter.INSTANCE;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Unsigned32ParameterConverter.INSTANCE;
            }
            case FLOAT: {
                if (Platform.getPlatform().getCPU() != Platform.CPU.I386 && Platform.getPlatform().getCPU() != Platform.CPU.X86_64) break;
                return Float32ParameterConverter.INSTANCE;
            }
        }
        throw Py.TypeError("cannot convert objects of type " + (Object)((Object)nativeType) + " to int");
    }

    final IntResultConverter getIntResultConverter(PyObject pyObject) {
        return this.getIntResultConverter(CType.typeOf(pyObject));
    }

    final IntResultConverter getIntResultConverter(CType cType) {
        return cType instanceof CType.Builtin ? this.getIntResultConverter(cType.getNativeType()) : null;
    }

    final IntResultConverter getIntResultConverter(NativeType nativeType) {
        switch (nativeType) {
            case VOID: {
                return VoidResultConverter.INSTANCE;
            }
            case BYTE: {
                return Signed8ResultConverter.INSTANCE;
            }
            case UBYTE: {
                return Unsigned8ResultConverter.INSTANCE;
            }
            case SHORT: {
                return Signed16ResultConverter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16ResultConverter.INSTANCE;
            }
            case INT: {
                return Signed32ResultConverter.INSTANCE;
            }
            case UINT: {
                return Unsigned32ResultConverter.INSTANCE;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Signed32ResultConverter.INSTANCE;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() != 32) break;
                return Unsigned32ResultConverter.INSTANCE;
            }
            case STRING: {
                if (Platform.getPlatform().addressSize() != 32) break;
                return StringResultConverter.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Cannot convert objects of type " + (Object)((Object)nativeType) + " from int");
    }

    private static abstract class BaseFastIntInvoker
    implements Invoker {
        final com.kenai.jffi.Invoker jffiInvoker = com.kenai.jffi.Invoker.getInstance();
        final Function function;
        final IntResultConverter resultConverter;
        final int arity;
        final IntParameterConverter c0;
        final IntParameterConverter c1;
        final IntParameterConverter c2;

        BaseFastIntInvoker(Function function, IntResultConverter intResultConverter, IntParameterConverter[] intParameterConverterArray) {
            this.function = function;
            this.resultConverter = intResultConverter;
            this.arity = intParameterConverterArray.length;
            this.c0 = intParameterConverterArray.length > 0 ? intParameterConverterArray[0] : null;
            this.c1 = intParameterConverterArray.length > 1 ? intParameterConverterArray[1] : null;
            this.c2 = intParameterConverterArray.length > 2 ? intParameterConverterArray[2] : null;
        }

        final void checkArity(PyObject[] pyObjectArray) {
            this.checkArity(pyObjectArray.length);
        }

        final void checkArity(int n) {
            if (n != this.arity) {
                throw Py.TypeError(String.format("__call__() takes exactly %d arguments (%d given)", this.arity, n));
            }
        }

        public PyObject invoke(PyObject[] pyObjectArray) {
            this.checkArity(pyObjectArray);
            switch (this.arity) {
                case 0: {
                    return this.invoke();
                }
                case 1: {
                    return this.invoke(pyObjectArray[0]);
                }
                case 2: {
                    return this.invoke(pyObjectArray[0], pyObjectArray[1]);
                }
                case 3: {
                    return this.invoke(pyObjectArray[0], pyObjectArray[1], pyObjectArray[2]);
                }
            }
            throw Py.RuntimeError("invalid fast-int arity");
        }

        public PyObject invoke() {
            this.checkArity(0);
            return Py.None;
        }

        public PyObject invoke(PyObject pyObject) {
            this.checkArity(1);
            return Py.None;
        }

        public PyObject invoke(PyObject pyObject, PyObject pyObject2) {
            this.checkArity(2);
            return Py.None;
        }

        public PyObject invoke(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            this.checkArity(3);
            return Py.None;
        }
    }

    static abstract class BaseParameterConverter
    implements IntParameterConverter {
        BaseParameterConverter() {
        }
    }

    static abstract class BaseResultConverter
    implements IntResultConverter {
        BaseResultConverter() {
        }
    }

    private static final class FastIntInvokerOne
    extends BaseFastIntInvoker {
        public FastIntInvokerOne(Function function, IntResultConverter intResultConverter, IntParameterConverter[] intParameterConverterArray) {
            super(function, intResultConverter, intParameterConverterArray);
        }

        public final PyObject invoke(PyObject pyObject) {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeIrI(this.function, this.c0.intValue(pyObject)));
        }
    }

    private static final class FastIntInvokerThree
    extends BaseFastIntInvoker {
        public FastIntInvokerThree(Function function, IntResultConverter intResultConverter, IntParameterConverter[] intParameterConverterArray) {
            super(function, intResultConverter, intParameterConverterArray);
        }

        public PyObject invoke(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeIIIrI(this.function, this.c0.intValue(pyObject), this.c1.intValue(pyObject2), this.c2.intValue(pyObject3)));
        }
    }

    private static final class FastIntInvokerTwo
    extends BaseFastIntInvoker {
        public FastIntInvokerTwo(Function function, IntResultConverter intResultConverter, IntParameterConverter[] intParameterConverterArray) {
            super(function, intResultConverter, intParameterConverterArray);
        }

        public PyObject invoke(PyObject pyObject, PyObject pyObject2) {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeIIrI(this.function, this.c0.intValue(pyObject), this.c1.intValue(pyObject2)));
        }
    }

    private static final class FastIntInvokerZero
    extends BaseFastIntInvoker {
        public FastIntInvokerZero(Function function, IntResultConverter intResultConverter, IntParameterConverter[] intParameterConverterArray) {
            super(function, intResultConverter, intParameterConverterArray);
        }

        public final PyObject invoke() {
            return this.resultConverter.pyValue(this.jffiInvoker.invokeVrI(this.function));
        }
    }

    static final class Float32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Float32ParameterConverter();

        Float32ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Float.floatToIntBits((float)pyObject.asDouble());
        }
    }

    private static interface IntParameterConverter {
        public int intValue(PyObject var1);
    }

    private static interface IntResultConverter {
        public PyObject pyValue(int var1);
    }

    static final class Signed16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed16ParameterConverter();

        Signed16ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Util.int16Value(pyObject);
        }
    }

    static final class Signed16ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Signed16ResultConverter();

        Signed16ResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newSigned16(n);
        }
    }

    static final class Signed32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed32ParameterConverter();

        Signed32ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Util.int32Value(pyObject);
        }
    }

    static final class Signed32ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Signed32ResultConverter();

        Signed32ResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newSigned32(n);
        }
    }

    static final class Signed8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Signed8ParameterConverter();

        Signed8ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Util.int8Value(pyObject);
        }
    }

    static final class Signed8ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Signed8ResultConverter();

        Signed8ResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newSigned8(n);
        }
    }

    private static final class SingletonHolder {
        private static final FastIntInvokerFactory INSTANCE = new FastIntInvokerFactory();

        private SingletonHolder() {
        }
    }

    static final class StringResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new StringResultConverter();

        StringResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newString(n);
        }
    }

    static final class Unsigned16ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned16ParameterConverter();

        Unsigned16ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Util.uint16Value(pyObject);
        }
    }

    static final class Unsigned16ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned16ResultConverter();

        Unsigned16ResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newUnsigned16(n);
        }
    }

    static final class Unsigned32ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned32ParameterConverter();

        Unsigned32ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Util.uint32Value(pyObject);
        }
    }

    static final class Unsigned32ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned32ResultConverter();

        Unsigned32ResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newUnsigned32(n);
        }
    }

    static final class Unsigned8ParameterConverter
    extends BaseParameterConverter {
        public static final IntParameterConverter INSTANCE = new Unsigned8ParameterConverter();

        Unsigned8ParameterConverter() {
        }

        public final int intValue(PyObject pyObject) {
            return Util.uint8Value(pyObject);
        }
    }

    static final class Unsigned8ResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new Unsigned8ResultConverter();

        Unsigned8ResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Util.newUnsigned8(n);
        }
    }

    static final class VoidResultConverter
    extends BaseResultConverter {
        public static final IntResultConverter INSTANCE = new VoidResultConverter();

        VoidResultConverter() {
        }

        public final PyObject pyValue(int n) {
            return Py.None;
        }
    }
}

